/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.config.JavalinConfig;
import io.javalin.event.EventManager;
import io.javalin.event.JavalinLifecycleEvent;
import io.javalin.http.servlet.ServletEntry;
import io.javalin.jetty.JettyResourceHandler;
import io.javalin.util.ConcurrencyUtil;
import io.javalin.util.JavalinBindException;
import io.javalin.util.JavalinException;
import io.javalin.util.JavalinLogger;
import io.javalin.util.Util;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u001f\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020 *\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020!*\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006'"}, d2={"Lio/javalin/jetty/JettyServer;", "", "cfg", "Lio/javalin/config/JavalinConfig;", "(Lio/javalin/config/JavalinConfig;)V", "eventManager", "Lio/javalin/event/EventManager;", "getEventManager", "()Lio/javalin/event/EventManager;", "eventManager$delegate", "Lkotlin/Lazy;", "started", "", "baseUrl", "", "Lorg/eclipse/jetty/server/ServerConnector;", "getBaseUrl", "(Lorg/eclipse/jetty/server/ServerConnector;)Ljava/lang/String;", "protocol", "getProtocol", "port", "", "server", "Lorg/eclipse/jetty/server/Server;", "start", "", "host", "(Ljava/lang/String;Ljava/lang/Integer;)V", "stop", "threadPool", "Lorg/eclipse/jetty/util/thread/ThreadPool;", "attachHandler", "Lorg/eclipse/jetty/server/handler/AbstractHandlerContainer;", "Lorg/eclipse/jetty/server/Handler;", "servletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "unwrap", "Lorg/eclipse/jetty/server/handler/HandlerWrapper;", "Companion", "javalin"})
@SourceDebugExtension(value={"SMAP\nJettyServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyServer.kt\nio/javalin/jetty/JettyServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,187:1\n1#2:188\n1855#3,2:189\n1855#3,2:191\n1855#3,2:193\n1549#3:195\n1620#3,3:196\n1855#3,2:199\n1855#3,2:212\n1855#3,2:217\n4098#4,11:201\n3792#4:214\n4307#4,2:215\n*S KotlinDebug\n*F\n+ 1 JettyServer.kt\nio/javalin/jetty/JettyServer\n*L\n71#1:189,2\n78#1:191,2\n81#1:193,2\n82#1:195\n82#1:196,3\n82#1:199,2\n120#1:212,2\n123#1:217,2\n120#1:201,11\n123#1:214\n123#1:215,2\n*E\n"})
public final class JettyServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavalinConfig cfg;
    private boolean started;
    @NotNull
    private final Lazy eventManager$delegate;

    public JettyServer(@NotNull JavalinConfig cfg) {
        Intrinsics.checkNotNullParameter(cfg, "cfg");
        this.cfg = cfg;
        Map<String, String> map = MimeTypes.getInferredEncodings();
        Intrinsics.checkNotNullExpressionValue(map, "getInferredEncodings(...)");
        Map<String, String> map2 = map;
        String string = "text/plain";
        String string2 = Charsets.UTF_8.name();
        map2.put(string, string2);
        if (this.cfg.startupWatcherEnabled) {
            new Thread(() -> JettyServer._init_$lambda$0(this)).start();
        }
        this.eventManager$delegate = LazyKt.lazy((Function0)new Function0<EventManager>(this){
            final /* synthetic */ JettyServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventManager invoke() {
                return JettyServer.access$getCfg$p((JettyServer)this.this$0).pvt.eventManager;
            }
        });
    }

    @NotNull
    public final ThreadPool threadPool() {
        ThreadPool threadPool = this.cfg.jetty.threadPool;
        if (threadPool == null) {
            ThreadPool threadPool2;
            ThreadPool it = threadPool2 = Companion.defaultThreadPool(this.cfg.useVirtualThreads);
            boolean bl = false;
            this.cfg.jetty.threadPool = it;
            threadPool = threadPool2;
        }
        return threadPool;
    }

    @NotNull
    public final Server server() {
        Server server = this.cfg.pvt.jetty.server;
        if (server == null) {
            Server server2;
            Server it = server2 = Companion.defaultServer(this.threadPool());
            boolean bl = false;
            this.cfg.pvt.jetty.server = it;
            server = server2;
        }
        return server;
    }

    public final int port() {
        Connector connector = this.server().getConnectors()[0];
        Intrinsics.checkNotNull(connector, "null cannot be cast to non-null type org.eclipse.jetty.server.ServerConnector");
        return ((ServerConnector)connector).getLocalPort();
    }

    public final boolean started() {
        return this.started;
    }

    private final EventManager getEventManager() {
        Lazy lazy = this.eventManager$delegate;
        return (EventManager)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@Nullable String host2, @Nullable Integer port) throws JavalinException {
        void $this$filterTo$iv$iv;
        void $this$forEach$iv;
        Object[] $this$filterIsInstanceTo$iv$iv;
        ServerConnector[] $this$forEach$iv2;
        Object $this$mapTo$iv$iv;
        void $this$start_u24lambda_u249_u24lambda_u245;
        Object element$iv;
        Util.printHelpfulMessageIfLoggerIsMissing();
        if (this.started) {
            throw new JavalinException("Server already started - Javalin instances cannot be reused.");
        }
        this.started = true;
        long startupTimer = System.currentTimeMillis();
        Server server = this.server();
        Object $this$start_u24lambda_u249 = server;
        boolean $i$a$-apply-JettyServer$start$232 = false;
        Object $this$forEach$iv22 = this.cfg.pvt.jetty.serverConsumers;
        boolean $i$f$forEach232 = false;
        Iterator iterator2 = $this$forEach$iv22.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            Consumer consumer = (Consumer)element$iv;
            boolean bl = false;
            consumer.accept($this$start_u24lambda_u249);
        }
        Object $i$f$forEach232 = $this$forEach$iv22 = new ServletContextHandler(1);
        Handler handler = ((HandlerWrapper)$this$start_u24lambda_u249).getHandler();
        ServerConnector[] serverConnectorArray = this;
        Object object = $this$start_u24lambda_u249;
        boolean bl = false;
        element$iv = this.cfg.pvt.servlet.getValue();
        ServletContainerInitializer servletContainerInitializer = ((ServletEntry)element$iv).component1();
        Servlet servlet2 = ((ServletEntry)element$iv).component2();
        if (servletContainerInitializer != null) {
            $this$start_u24lambda_u249_u24lambda_u245.addServletContainerInitializer(servletContainerInitializer);
        }
        $this$start_u24lambda_u249_u24lambda_u245.setContextPath(Util.normalizeContextPath(this.cfg.router.contextPath));
        $this$start_u24lambda_u249_u24lambda_u245.setSessionHandler(Companion.defaultSessionHandler());
        $this$start_u24lambda_u249_u24lambda_u245.addServlet(new ServletHolder(servlet2), "/*");
        Iterable $this$forEach$iv3 = this.cfg.pvt.jetty.servletContextHandlerConsumers;
        boolean bl2 = false;
        for (Object element$iv2 : $this$forEach$iv3) {
            Consumer it = (Consumer)element$iv2;
            boolean bl22 = false;
            it.accept($this$start_u24lambda_u249_u24lambda_u245);
        }
        Unit unit = Unit.INSTANCE;
        ((HandlerWrapper)object).setHandler(serverConnectorArray.attachHandler(handler, (ServletContextHandler)$this$forEach$iv22));
        HttpConfiguration httpConfiguration = Companion.defaultHttpConfiguration();
        Iterable $this$forEach$iv4 = this.cfg.pvt.jetty.httpConfigurationConfigs;
        boolean $i$f$forEach3 = false;
        for (Object e : $this$forEach$iv4) {
            Consumer it = (Consumer)e;
            boolean bl3 = false;
            it.accept(httpConfiguration);
        }
        Iterable $this$map$iv = this.cfg.pvt.jetty.connectors;
        boolean $i$f$map = false;
        element$iv = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t2 : $this$mapTo$iv$iv) {
            void it;
            BiFunction biFunction = (BiFunction)t2;
            object = collection;
            boolean bl4 = false;
            object.add((Connector)it.apply($this$start_u24lambda_u249, httpConfiguration));
        }
        $this$map$iv = (List)collection;
        boolean $i$f$forEach42 = false;
        for (Object t3 : $this$forEach$iv2) {
            Connector p0 = (Connector)t3;
            boolean bl5 = false;
            ((Server)$this$start_u24lambda_u249).addConnector(p0);
        }
        Connector[] connectorArray = ((Server)$this$start_u24lambda_u249).getConnectors();
        Intrinsics.checkNotNullExpressionValue(connectorArray, "getConnectors(...)");
        if (((Object[])connectorArray).length == 0) {
            void $this$start_u24lambda_u249_u24lambda_u248;
            $this$forEach$iv2 = new ServerConnector[1];
            Object $i$f$forEach42 = new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)};
            $this$mapTo$iv$iv = $i$f$forEach42 = new ServerConnector(((AbstractHandler)$this$start_u24lambda_u249).getServer(), (ConnectionFactory)$i$f$forEach42);
            int n = 0;
            serverConnectorArray = $this$forEach$iv2;
            object = $this$start_u24lambda_u249;
            boolean bl3 = false;
            String string = host2;
            if (string == null) {
                string = this.cfg.jetty.defaultHost;
            }
            $this$start_u24lambda_u249_u24lambda_u248.setHost(string);
            Integer n2 = port;
            $this$start_u24lambda_u249_u24lambda_u248.setPort(n2 != null ? n2 : this.cfg.jetty.defaultPort);
            unit = Unit.INSTANCE;
            serverConnectorArray[n] = $i$f$forEach42;
            ((Server)object).setConnectors($this$forEach$iv2);
        }
        this.getEventManager().fireEvent(JavalinLifecycleEvent.SERVER_STARTING);
        try {
            JavalinLogger.startup("Starting Javalin ...");
            this.server().start();
        }
        catch (Exception e) {
            JavalinLogger.error$default("Failed to start Javalin", null, 2, null);
            this.getEventManager().fireEvent(JavalinLifecycleEvent.SERVER_START_FAILED);
            if (Intrinsics.areEqual(this.server().getAttribute("is-default-server"), true)) {
                this.server().stop();
            }
            if (e.getMessage() != null) {
                String string = e.getMessage();
                Intrinsics.checkNotNull(string);
                if (StringsKt.contains$default((CharSequence)string, "Failed to bind to", false, 2, null)) {
                    throw new JavalinBindException("Port already in use. Make sure no other process is using port " + Util.getPort(e) + " and try again.", e);
                }
            }
            if (e.getMessage() != null) {
                String string = e.getMessage();
                Intrinsics.checkNotNull(string);
                if (StringsKt.contains$default((CharSequence)string, "Permission denied", false, 2, null)) {
                    throw new JavalinBindException("Port 1-1023 require elevated privileges (process must be started by admin).", e);
                }
            }
            throw new JavalinException(e);
        }
        if (this.cfg.showJavalinBanner) {
            JavalinLogger.startup("\n       __                  ___           _____\n      / /___ __   ______ _/ (_)___      / ___/\n __  / / __ `/ | / / __ `/ / / __ \\    / __ \\\n/ /_/ / /_/ /| |/ / /_/ / / / / / /   / /_/ /\n\\____/\\__,_/ |___/\\__,_/_/_/_/ /_/    \\____/\n\n       https://javalin.io/documentation\n");
        }
        JavalinLogger.startup("Javalin started in " + (System.currentTimeMillis() - startupTimer) + "ms \\o/");
        $this$start_u24lambda_u249 = this.cfg.pvt.resourceHandler;
        JettyResourceHandler jettyResourceHandler = $this$start_u24lambda_u249 instanceof JettyResourceHandler ? (JettyResourceHandler)$this$start_u24lambda_u249 : null;
        if (jettyResourceHandler != null) {
            jettyResourceHandler.init();
        }
        Connector[] connectorArray2 = this.server().getConnectors();
        Intrinsics.checkNotNullExpressionValue(connectorArray2, "getConnectors(...)");
        Object $this$filterIsInstance$iv = connectorArray2;
        boolean $i$f$filterIsInstance = false;
        Object[] $i$a$-apply-JettyServer$start$232 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void var12_31 : $this$filterIsInstanceTo$iv$iv) {
            if (!(var12_31 instanceof ServerConnector)) continue;
            destination$iv$iv2.add(var12_31);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach5 = false;
        for (Object element$iv4 : $this$forEach$iv) {
            ServerConnector it = (ServerConnector)element$iv4;
            int n = 0;
            JavalinLogger.startup("Listening on " + super.getBaseUrl(it));
        }
        Connector[] connectorArray3 = this.server().getConnectors();
        Intrinsics.checkNotNullExpressionValue(connectorArray3, "getConnectors(...)");
        Object $this$filter$iv = connectorArray3;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void var12_32 : $this$filterTo$iv$iv) {
            Connector it = (Connector)var12_32;
            boolean bl7 = false;
            if (!(!(it instanceof ServerConnector))) continue;
            destination$iv$iv.add(var12_32);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Connector it = (Connector)element$iv2;
            boolean bl8 = false;
            JavalinLogger.startup("Binding to: " + it);
        }
        Util.logJavalinVersion();
        super.getEventManager().fireEvent(JavalinLifecycleEvent.SERVER_STARTED);
    }

    public final void stop() {
        JavalinLogger.info$default("Stopping Javalin ...", null, 2, null);
        this.getEventManager().fireEvent(JavalinLifecycleEvent.SERVER_STOPPING);
        try {
            this.server().stop();
        }
        catch (Exception e) {
            this.getEventManager().fireEvent(JavalinLifecycleEvent.SERVER_STOP_FAILED);
            JavalinLogger.error("Javalin failed to stop gracefully", e);
            throw new JavalinException(e);
        }
        JavalinLogger.info$default("Javalin has stopped", null, 2, null);
        this.getEventManager().fireEvent(JavalinLifecycleEvent.SERVER_STOPPED);
    }

    private final AbstractHandlerContainer attachHandler(Handler $this$attachHandler, ServletContextHandler servletContextHandler) {
        AbstractHandlerContainer abstractHandlerContainer;
        if ($this$attachHandler == null) {
            abstractHandlerContainer = servletContextHandler;
        } else if ($this$attachHandler instanceof HandlerCollection) {
            Handler handler = $this$attachHandler;
            HandlerCollection $this$attachHandler_u24lambda_u2413 = (HandlerCollection)handler;
            boolean bl = false;
            $this$attachHandler_u24lambda_u2413.addHandler(servletContextHandler);
            abstractHandlerContainer = (AbstractHandlerContainer)handler;
        } else if ($this$attachHandler instanceof HandlerWrapper) {
            Handler handler = $this$attachHandler;
            HandlerWrapper $this$attachHandler_u24lambda_u2414 = (HandlerWrapper)handler;
            boolean bl = false;
            Handler handler2 = this.unwrap($this$attachHandler_u24lambda_u2414);
            HandlerCollection handlerCollection = handler2 instanceof HandlerCollection ? (HandlerCollection)handler2 : null;
            if (handlerCollection != null) {
                handlerCollection.addHandler(servletContextHandler);
            }
            handler2 = this.unwrap($this$attachHandler_u24lambda_u2414);
            HandlerWrapper handlerWrapper = handler2 instanceof HandlerWrapper ? (HandlerWrapper)handler2 : null;
            if (handlerWrapper != null) {
                handlerWrapper.setHandler(servletContextHandler);
            }
            abstractHandlerContainer = (AbstractHandlerContainer)handler;
        } else {
            throw new IllegalStateException("Server has unsupported Handler attached to it (must be HandlerCollection or HandlerWrapper)");
        }
        return abstractHandlerContainer;
    }

    private final Handler unwrap(HandlerWrapper $this$unwrap) {
        Handler handler;
        Handler handler2 = $this$unwrap.getHandler();
        if (handler2 == null) {
            handler = $this$unwrap;
        } else if (handler2 instanceof HandlerCollection) {
            Handler handler3 = $this$unwrap.getHandler();
            handler = handler3;
            Intrinsics.checkNotNullExpressionValue(handler3, "getHandler(...)");
        } else if (handler2 instanceof HandlerWrapper) {
            Handler handler4 = $this$unwrap.getHandler();
            Intrinsics.checkNotNull(handler4, "null cannot be cast to non-null type org.eclipse.jetty.server.handler.HandlerWrapper");
            handler = this.unwrap((HandlerWrapper)handler4);
        } else {
            throw new IllegalStateException("HandlerWrapper has unsupported Handler type (must be HandlerCollection or HandlerWrapper");
        }
        return handler;
    }

    private final String getProtocol(ServerConnector $this$protocol) {
        return $this$protocol.getProtocols().contains("ssl") ? "https" : "http";
    }

    private final String getBaseUrl(ServerConnector $this$baseUrl) {
        String string = this.getProtocol($this$baseUrl);
        String string2 = $this$baseUrl.getHost();
        if (string2 == null) {
            string2 = "localhost";
        }
        return string + "://" + string2 + ":" + $this$baseUrl.getLocalPort() + this.cfg.router.contextPath;
    }

    private static final void _init_$lambda$0(JettyServer this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Thread.sleep(5000L);
        if (!this$0.started) {
            JavalinLogger.startup("It looks like you created a Javalin instance, but you never started it.");
            JavalinLogger.startup("Try: Javalin app = Javalin.create().start();");
            JavalinLogger.startup("For more help, visit https://javalin.io/documentation#server-setup");
        }
    }

    public static final /* synthetic */ JavalinConfig access$getCfg$p(JettyServer $this) {
        return $this.cfg;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lio/javalin/jetty/JettyServer$Companion;", "", "()V", "defaultHttpConfiguration", "Lorg/eclipse/jetty/server/HttpConfiguration;", "defaultServer", "Lorg/eclipse/jetty/server/Server;", "threadPool", "Lorg/eclipse/jetty/util/thread/ThreadPool;", "defaultSessionHandler", "Lorg/eclipse/jetty/server/session/SessionHandler;", "defaultThreadPool", "useVirtualThreads", "", "javalin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadPool defaultThreadPool(boolean useVirtualThreads) {
            return ConcurrencyUtil.jettyThreadPool("JettyServerThreadPool", 8, 250, useVirtualThreads);
        }

        @NotNull
        public final Server defaultServer(@NotNull ThreadPool threadPool) {
            Server server;
            Intrinsics.checkNotNullParameter(threadPool, "threadPool");
            Server $this$defaultServer_u24lambda_u240 = server = new Server(threadPool);
            boolean bl = false;
            $this$defaultServer_u24lambda_u240.addBean(new LowResourceMonitor($this$defaultServer_u24lambda_u240));
            $this$defaultServer_u24lambda_u240.insertHandler(new StatisticsHandler());
            $this$defaultServer_u24lambda_u240.setAttribute("is-default-server", true);
            return server;
        }

        @NotNull
        public final HttpConfiguration defaultHttpConfiguration() {
            HttpConfiguration httpConfiguration;
            HttpConfiguration $this$defaultHttpConfiguration_u24lambda_u241 = httpConfiguration = new HttpConfiguration();
            boolean bl = false;
            $this$defaultHttpConfiguration_u24lambda_u241.setUriCompliance(UriCompliance.RFC3986);
            $this$defaultHttpConfiguration_u24lambda_u241.setSendServerVersion(false);
            return httpConfiguration;
        }

        @NotNull
        public final SessionHandler defaultSessionHandler() {
            SessionHandler sessionHandler;
            SessionHandler $this$defaultSessionHandler_u24lambda_u242 = sessionHandler = new SessionHandler();
            boolean bl = false;
            $this$defaultSessionHandler_u24lambda_u242.setHttpOnly(true);
            $this$defaultSessionHandler_u24lambda_u242.setSameSite(HttpCookie.SameSite.LAX);
            return sessionHandler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

