/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin;

import io.javalin.config.JavalinConfig;
import io.javalin.plugin.ContextPlugin;
import io.javalin.plugin.Plugin;
import io.javalin.plugin.PluginAlreadyRegisteredException;
import io.javalin.plugin.PluginNotRegisteredException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\f0\u000b\"\u0004\b\u0000\u0010\f2\u0018\u0010\r\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\f0\u000b0\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/javalin/plugin/PluginManager;", "", "cfg", "Lio/javalin/config/JavalinConfig;", "(Lio/javalin/config/JavalinConfig;)V", "enabledPlugins", "", "Lio/javalin/plugin/Plugin;", "initializedPlugins", "plugins", "getContextPlugin", "Lio/javalin/plugin/ContextPlugin;", "T", "clazz", "Ljava/lang/Class;", "initializePlugins", "", "register", "plugin", "startPlugins", "javalin"})
@SourceDebugExtension(value={"SMAP\nPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManager.kt\nio/javalin/plugin/PluginManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1747#2,3:49\n603#3:52\n603#3:53\n1313#3,2:54\n1#4:56\n*S KotlinDebug\n*F\n+ 1 PluginManager.kt\nio/javalin/plugin/PluginManager\n*L\n12#1:49,3\n24#1:52\n37#1:53\n38#1:54,2\n*E\n"})
public final class PluginManager {
    @NotNull
    private final JavalinConfig cfg;
    @NotNull
    private final List<Plugin<?>> plugins;
    @NotNull
    private final List<Plugin<?>> initializedPlugins;
    @NotNull
    private final List<Plugin<?>> enabledPlugins;

    public PluginManager(@NotNull JavalinConfig cfg) {
        Intrinsics.checkNotNullParameter(cfg, "cfg");
        this.cfg = cfg;
        this.plugins = new ArrayList();
        this.initializedPlugins = new ArrayList();
        this.enabledPlugins = new ArrayList();
    }

    public final void register(@NotNull Plugin<?> plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        if (!plugin.repeatable()) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = this.plugins;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Plugin it = (Plugin)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getClass(), plugin.getClass())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new PluginAlreadyRegisteredException(plugin);
            }
        }
        this.plugins.add(plugin);
        this.initializePlugins();
    }

    private final void initializePlugins() {
        while (this.plugins.size() != this.initializedPlugins.size()) {
            Sequence $this$sortedBy$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.plugins), new Function1<Plugin<?>, Boolean>(this){
                final /* synthetic */ PluginManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Plugin<?> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return !PluginManager.access$getInitializedPlugins$p(this.this$0).contains(it);
                }
            });
            boolean $i$f$sortedBy = false;
            Sequence pluginsToInitialize2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Plugin it = (Plugin)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.priority());
                    it = (Plugin)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.priority()));
                }
            });
            Iterator iterator2 = pluginsToInitialize2.iterator();
            while (iterator2.hasNext()) {
                Plugin plugin = (Plugin)iterator2.next();
                this.initializedPlugins.add(plugin);
                plugin.onInitialize(this.cfg);
            }
        }
    }

    public final void startPlugins() {
        Sequence $this$sortedBy$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.initializedPlugins), new Function1<Plugin<?>, Boolean>(this){
            final /* synthetic */ PluginManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Plugin<?> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !PluginManager.access$getEnabledPlugins$p(this.this$0).contains(it);
            }
        });
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Plugin it = (Plugin)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.priority());
                it = (Plugin)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.priority()));
            }
        });
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Plugin it = (Plugin)element$iv;
            boolean bl = false;
            it.onStart(this.cfg);
            this.enabledPlugins.add(it);
        }
    }

    @NotNull
    public final <T> ContextPlugin<?, T> getContextPlugin(@NotNull Class<? extends ContextPlugin<?, T>> clazz) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(clazz, "clazz");
            Iterable iterable = this.plugins;
            for (Object t2 : iterable) {
                Plugin it = (Plugin)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getClass(), clazz)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        Plugin plugin = v0;
        if (plugin == null) {
            throw new PluginNotRegisteredException(clazz);
        }
        return (ContextPlugin)plugin;
    }

    public static final /* synthetic */ List access$getInitializedPlugins$p(PluginManager $this) {
        return $this.initializedPlugins;
    }

    public static final /* synthetic */ List access$getEnabledPlugins$p(PluginManager $this) {
        return $this.enabledPlugins;
    }
}

