/*
 * Decompiled with CFR 0.152.
 */
package nl.thomasgoossen.gooselib.client;

import com.esotericsoftware.kryonet.Connection;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import nl.thomasgoossen.gooselib.client.GLClient;
import nl.thomasgoossen.gooselib.shared.EncryptedPacket;
import nl.thomasgoossen.gooselib.shared.messages.ChunkUploadResp;
import nl.thomasgoossen.gooselib.shared.messages.UploadReq;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class Upload {
    private static final String UPLOAD_FILE = "./temp.tar.gz";
    public static final int CHUNK_SIZE = 65536;
    private static String curUploadName = "undefined";
    private static String status = "idle";
    private static int chunkCount = 0;
    private static long totalLength = -1L;
    private static int curChunk = -1;
    private static FileInputStream fis;

    public static void upload(String password, String folder, String name, String version) {
        curUploadName = name;
        System.out.println("compressing...");
        Upload.compress(folder, UPLOAD_FILE);
        if (!Files.exists(Paths.get(UPLOAD_FILE, new String[0]), new LinkOption[0])) {
            System.out.println("no upload file detected, stopping upload");
            return;
        }
        File f = new File(UPLOAD_FILE);
        chunkCount = (int)Math.ceil((double)f.length() / 65536.0);
        System.out.println("chunks: " + chunkCount);
        UploadReq req = new UploadReq(password, name, version, chunkCount, 65536);
        GLClient.sendPacketTCP(req);
        status = "uploading";
    }

    private static void compress(String src, String out) {
        status = "compressing";
        Path sourcePath = Paths.get(src, new String[0]);
        try (FileOutputStream fos = new FileOutputStream(out);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             GzipCompressorOutputStream gzos = new GzipCompressorOutputStream(bos);
             TarArchiveOutputStream taos = new TarArchiveOutputStream(gzos);){
            taos.setLongFileMode(2);
            taos.setBigNumberMode(2);
            Files.walk(sourcePath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                TarArchiveEntry entry = new TarArchiveEntry(path.toFile(), sourcePath.relativize((Path)path).toString());
                try {
                    taos.putArchiveEntry(entry);
                    Files.copy(path, taos);
                    taos.closeArchiveEntry();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            });
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static byte[] getChunk(int chunkIndex) {
        byte[] byArray;
        long begin = chunkIndex * 65536;
        long end = begin + 65536L;
        if (totalLength < 0L) {
            File f = new File(UPLOAD_FILE);
            totalLength = f.length();
        }
        if (end >= totalLength) {
            end = totalLength;
        }
        RandomAccessFile raf = new RandomAccessFile(UPLOAD_FILE, "r");
        try {
            raf.seek(begin);
            long length = end - begin;
            byte[] buff = new byte[(int)length];
            raf.readFully(buff);
            byArray = buff;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }
        raf.close();
        return byArray;
    }

    public static void sendNextBytes(Connection conn) throws IOException {
        byte[] buff;
        int bRead;
        if (fis == null || curChunk == -1) {
            curChunk = 0;
            fis = new FileInputStream(UPLOAD_FILE);
        }
        if ((bRead = fis.read(buff = new byte[65536], 0, 65536)) > 0) {
            byte[] actual = new byte[65536];
            if (bRead < 65536) {
                actual = new byte[bRead];
            }
            System.arraycopy(buff, 0, actual, 0, bRead);
            ChunkUploadResp resp = new ChunkUploadResp(curUploadName, curChunk, actual);
            conn.sendTCP(new EncryptedPacket(resp));
            ++curChunk;
        }
    }

    public static String getStatus() {
        return status;
    }

    public static String getCurUploadName() {
        return curUploadName;
    }

    public static void done() {
        if (fis != null) {
            try {
                fis.close();
                fis = null;
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        status = "done";
        File f = new File(UPLOAD_FILE);
        f.delete();
    }

    public static int getChunkCount() {
        return chunkCount;
    }
}

