/*
 * Decompiled with CFR 0.152.
 */
package nl.thomasgoossen.gooselib.client;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import nl.thomasgoossen.gooselib.client.Download;

public class DownloadBuffer {
    public final int totalCount;
    private final String name;
    private int lastAppended = -1;
    private long bytesAppended = 0L;
    private final ConcurrentHashMap<Integer, byte[]> recvBuffer;
    private final List<Integer> toRecv;
    private final FileOutputStream fos;
    public final ScheduledExecutorService scheduler;

    public DownloadBuffer(String name, int totalCount, FileOutputStream fos, int laOffset) {
        this.name = name;
        this.totalCount = totalCount;
        this.toRecv = Collections.synchronizedList(new ArrayList());
        this.recvBuffer = new ConcurrentHashMap();
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.fos = fos;
        this.lastAppended = laOffset;
        int offset = 0;
        if (laOffset > 0) {
            offset = laOffset + 1;
        }
        for (int i = offset; i < totalCount; ++i) {
            this.toRecv.add(i);
        }
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.pushBuffer();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }, 100L, 1000L, TimeUnit.MILLISECONDS);
        System.out.println("created new download buffer with " + this.toRecv.size() + " expected chunks");
    }

    public void addToBuffer(int index, byte[] chunk) {
        if (this.toRecv.contains(index)) {
            if (index == this.totalCount - 1) {
                System.out.println("last chunk received!");
            }
            this.recvBuffer.put(index, chunk);
            this.toRecv.remove(this.toRecv.indexOf(index));
        }
    }

    public void pushBuffer() throws IOException {
        HashMap<Integer, byte[]> buffer = new HashMap<Integer, byte[]>();
        for (Integer key : this.recvBuffer.keySet()) {
            buffer.put(key, this.recvBuffer.get(key));
        }
        ArrayList<Integer> keysToRemove = new ArrayList<Integer>();
        if (!buffer.isEmpty()) {
            while (buffer.containsKey(this.lastAppended + 1)) {
                byte[] c = (byte[])buffer.get(this.lastAppended + 1);
                this.fos.write(c);
                this.bytesAppended += (long)c.length;
                keysToRemove.add(this.lastAppended + 1);
                ++this.lastAppended;
            }
        }
        buffer.clear();
        Object object = keysToRemove.iterator();
        while (object.hasNext()) {
            int i = (Integer)object.next();
            this.recvBuffer.remove(i);
        }
        if (this.lastAppended == this.totalCount - 1) {
            object = this.fos;
            try {
                if (!this.toRecv.isEmpty()) {
                    System.out.println("toRecv should be emtpy yet contains: ");
                    for (int index : this.toRecv) {
                        System.out.println(index);
                    }
                }
                if (!this.recvBuffer.isEmpty()) {
                    System.out.println("recvBuffer should be empty yet contains: ");
                    Iterator iterator2 = ((ConcurrentHashMap.KeySetView)this.recvBuffer.keySet()).iterator();
                    while (iterator2.hasNext()) {
                        int index;
                        index = (Integer)iterator2.next();
                        System.out.println(index);
                    }
                }
            }
            finally {
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
            }
            System.out.println("writes finished, scheduler shutting down...");
            this.scheduler.shutdown();
            Download.finish(this.name);
        }
    }

    public int getLastAppended() {
        return this.lastAppended;
    }

    public long getBytesAppended() {
        return this.bytesAppended;
    }

    public boolean isDone() {
        return this.toRecv.isEmpty() && this.recvBuffer.isEmpty();
    }

    public int next(List<Integer> alreadyExpected) {
        if (this.toRecv.isEmpty()) {
            return -1;
        }
        int next = this.toRecv.get(0);
        int i = 0;
        while (alreadyExpected.contains(next)) {
            next = this.toRecv.get(++i);
        }
        return next;
    }

    public List<Integer> getToRecv() {
        return this.toRecv;
    }
}

