/*
 * Decompiled with CFR 0.152.
 */
package nl.thomasgoossen.gooselib.client;

import com.esotericsoftware.minlog.Log;
import io.javalin.Javalin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import nl.thomasgoossen.gooselib.client.ConnectionInstance;
import nl.thomasgoossen.gooselib.client.ConnectionStatus;
import nl.thomasgoossen.gooselib.client.Download;
import nl.thomasgoossen.gooselib.client.ErrorWrapper;
import nl.thomasgoossen.gooselib.client.Handshake;
import nl.thomasgoossen.gooselib.client.Upload;
import nl.thomasgoossen.gooselib.shared.AppMetaData;
import nl.thomasgoossen.gooselib.shared.messages.HandshakeResp;
import nl.thomasgoossen.gooselib.shared.messages.LibInfoReq;
import nl.thomasgoossen.gooselib.shared.messages.PutUserReq;
import nl.thomasgoossen.gooselib.shared.messages.SetExecPathReq;

public class GLClient {
    private static final int PORT = 7123;
    private static final int TIMEOUT = 5000;
    private static AppMetaData[] metaData = null;
    private static volatile boolean metaSignal = false;
    private static String username;
    private static String password;
    private static volatile ConnectionInstance connection;
    private static volatile long lastReq;

    public static void main(String[] args2) {
        Log.set(5);
        Javalin app = Javalin.create();
        app = GLClient.lastReqUpdater(app);
        app = GLClient.statusHandler(app);
        app = GLClient.stopHandler(app);
        app = GLClient.setUsernameHandler(app);
        app = GLClient.setPasswordHandler(app);
        app = GLClient.handshakeHandler(app);
        app = GLClient.downloadHandler(app);
        app = GLClient.downloadProgressHandler(app);
        app = GLClient.uploadHandler(app);
        app = GLClient.uploadStatusHandler(app);
        app = GLClient.metaDataHandler(app);
        app = GLClient.connectionStatusHandler(app);
        app = GLClient.setExecPathHandler(app);
        app = GLClient.putUserHandler(app);
        app.start(7123);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("running shutdown hook");
                if (connection != null) {
                    connection.stop();
                }
                Download.kill();
            }
        });
        if (!GLClient.checkFlag(args2, "notimeout")) {
            Runnable checkTimeout = () -> {
                if (System.currentTimeMillis() - lastReq > 5000L) {
                    System.out.println("Timeout, exiting..");
                    System.exit(0);
                }
            };
            lastReq = System.currentTimeMillis();
            ScheduledExecutorService executor2 = Executors.newScheduledThreadPool(1);
            executor2.scheduleAtFixedRate(checkTimeout, 0L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    private static boolean checkFlag(String[] args2, String flag) {
        for (String a : args2) {
            if (!a.toLowerCase().replace("-", "").equals(flag.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static Javalin lastReqUpdater(Javalin app) {
        return (Javalin)app.before(ctx -> {
            lastReq = System.currentTimeMillis();
        });
    }

    private static Javalin statusHandler(Javalin app) {
        return (Javalin)app.get("/", ctx -> ctx.result("http server is running"));
    }

    private static Javalin stopHandler(final Javalin app) {
        return (Javalin)app.get("/stop", ctx -> {
            ctx.result("Ok, stopping..");
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    app.stop();
                    System.exit(0);
                }
            }, 100L);
        });
    }

    private static Javalin setUsernameHandler(Javalin app) {
        return (Javalin)app.post("/set-user/{name}", ctx -> {
            username = ctx.pathParam("name");
            ctx.result("Set username to: " + username);
        });
    }

    private static Javalin setPasswordHandler(Javalin app) {
        return (Javalin)app.post("/set-password/{password}", ctx -> {
            password = ctx.pathParam("password");
            ctx.result("Set password to: " + password);
        });
    }

    private static Javalin handshakeHandler(Javalin app) {
        return (Javalin)app.post("/handshake/{ip}", ctx -> {
            if (!Handshake.isHandshaking && username != null && password != null) {
                if (connection != null) {
                    connection.stop();
                }
                String ip2 = ctx.pathParam("ip");
                HandshakeResp resp = null;
                try {
                    resp = Handshake.performHandshake(ip2, username, password);
                }
                catch (IOException | InterruptedException e) {
                    ctx.json(new ErrorWrapper(e.getMessage()));
                }
                if (resp != null) {
                    connection = new ConnectionInstance(ip2, resp);
                    ctx.json(resp);
                } else {
                    ctx.json(new ErrorWrapper(Handshake.getError()));
                }
            } else {
                ctx.json(new ErrorWrapper("already handshaking..."));
            }
        });
    }

    private static Javalin downloadHandler(Javalin app) {
        return (Javalin)app.post("/download/{appName}/{dst}", ctx -> {
            if (connection != null && metaData != null) {
                String dst = ctx.pathParam("dst");
                String appName = ctx.pathParam("appName");
                int appIndex = -1;
                int i = 0;
                for (AppMetaData meta : metaData) {
                    if (meta.name.equals(appName)) {
                        appIndex = i;
                        break;
                    }
                    ++i;
                }
                dst = dst.replace("[", "");
                dst = dst.replace("]", "");
                dst = dst.replace("!", "/");
                System.out.println("downloading to: " + Paths.get(dst, new String[0]).toAbsolutePath());
                if (appIndex >= 0 && appIndex < metaData.length) {
                    AppMetaData meta = metaData[appIndex];
                    ctx.result("started download with name " + meta.name);
                    try {
                        Download d = new Download(meta, dst);
                        System.out.println("started download instance with name: " + d.getName());
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(e.getMessage());
                    }
                } else {
                    ctx.result("could not start download");
                }
            }
        });
    }

    private static Javalin downloadProgressHandler(Javalin app) {
        return (Javalin)app.get("/download-progress", ctx -> ctx.json(Download.getDownloadInfos()));
    }

    private static Javalin uploadHandler(Javalin app) {
        return (Javalin)app.post("/upload/{path}/{name}/{adminPass}", ctx -> {
            if (connection != null) {
                String path = ctx.pathParam("path");
                String name = ctx.pathParam("name");
                String adminPass = ctx.pathParam("adminPass");
                String version = new SimpleDateFormat("dd-MM HH:mm:ss").format(new Date());
                path = path.replace("[", "");
                path = path.replace("]", "");
                path = path.replace("!", "/");
                path = path.replace("*", ":");
                System.out.println("starting upload with vars:");
                System.out.println("path: " + Paths.get(path, new String[0]).toAbsolutePath());
                System.out.println("name: " + name);
                System.out.println("version: " + version);
                String lPath = path;
                if (Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
                    ctx.result("starting upload");
                    new Thread(() -> Upload.upload(adminPass, lPath, name, version)).start();
                } else {
                    String absPath = Paths.get(lPath, new String[0]).toAbsolutePath().toString();
                    ctx.result("path " + absPath + " is not a folder");
                }
            } else {
                ctx.result("connection not initialized");
            }
        });
    }

    private static Javalin uploadStatusHandler(Javalin app) {
        return (Javalin)app.get("/upload-status", ctx -> ctx.result(Upload.getStatus()));
    }

    private static Javalin metaDataHandler(Javalin app) {
        return (Javalin)app.get("/meta", ctx -> {
            if (connection != null) {
                LibInfoReq req = new LibInfoReq(username, password);
                GLClient.sendPacketTCP(req);
                long startTime = System.currentTimeMillis();
                while (!metaSignal && System.currentTimeMillis() - startTime <= 5000L) {
                }
            }
            if (metaData != null) {
                ctx.json(metaData);
            } else {
                ctx.json(new AppMetaData[0]);
            }
        });
    }

    private static Javalin connectionStatusHandler(Javalin app) {
        return (Javalin)app.get("/connection", ctx -> {
            boolean b;
            boolean bl = b = connection != null;
            if (!b) {
                ctx.json(new ConnectionStatus(b));
            } else {
                ctx.json(new ConnectionStatus(connection.isConnected()));
            }
        });
    }

    private static Javalin setExecPathHandler(Javalin app) {
        return (Javalin)app.post("/set-exec-path/{appName}/{path}/{adminPass}", ctx -> {
            String appName = ctx.pathParam("appName");
            String path = ctx.pathParam("path");
            String adminPass = ctx.pathParam("adminPass");
            path = path.replace("[", "");
            path = path.replace("]", "");
            path = path.replace("!", "/");
            System.out.println(appName);
            System.out.println(path);
            System.out.println(adminPass);
            SetExecPathReq req = new SetExecPathReq(appName, path, adminPass);
            GLClient.sendPacketTCP(req);
            ctx.result("sent request");
        });
    }

    private static Javalin putUserHandler(Javalin app) {
        return (Javalin)app.post("/put-user/{username}/{pass}/{adminPass}", ctx -> {
            String usr = ctx.pathParam("username");
            String pass = ctx.pathParam("pass");
            String adminPass = ctx.pathParam("adminPass");
            PutUserReq req = new PutUserReq(adminPass, usr, pass);
            GLClient.sendPacketTCP(req);
            ctx.result("sent put user request");
        });
    }

    public static void sendPlainPacketTCP(Object data) {
        if (connection != null) {
            connection.sendPlainPacketTCP(data);
        }
    }

    public static void sendPlainPacketUDP(Object data) {
        if (connection != null) {
            connection.sendPlainPacketUDP(data);
        }
    }

    public static void sendPacketTCP(Object data) {
        if (connection != null) {
            connection.sendPacketTCP(data);
        }
    }

    public static void sendPacketUDP(Object data) {
        if (connection != null) {
            connection.sendPacketUDP(data);
        }
    }

    public static String getPassword() {
        return password;
    }

    public static String getUsername() {
        return username;
    }

    public static void setMetaSignal() {
        metaSignal = true;
    }

    public static void setMetaData(AppMetaData[] metaData) {
        GLClient.metaData = metaData;
    }
}

