/*
 * Decompiled with CFR 0.152.
 */
package nl.thomasgoossen.gooselib.client;

import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import java.io.IOException;
import nl.thomasgoossen.gooselib.shared.EncryptedPacket;
import nl.thomasgoossen.gooselib.shared.KryoHelper;
import nl.thomasgoossen.gooselib.shared.messages.AuthError;
import nl.thomasgoossen.gooselib.shared.messages.HandshakeReq;
import nl.thomasgoossen.gooselib.shared.messages.HandshakeResp;

public class Handshake {
    private static final int MANAGER_PORT = 61234;
    private static boolean receivedResp = false;
    private static volatile HandshakeResp resp = null;
    private static volatile String err = null;
    private static final Object lock = new Object();
    public static boolean isHandshaking = false;

    private static Listener listener() {
        return new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void received(Connection connection, Object obj) {
                Object object = lock;
                synchronized (object) {
                    if (obj instanceof EncryptedPacket) {
                        EncryptedPacket pkt = (EncryptedPacket)obj;
                        Object decoded = pkt.getDataObject(null);
                        if (decoded instanceof HandshakeResp) {
                            resp = (HandshakeResp)decoded;
                        } else {
                            err = decoded instanceof AuthError ? ((AuthError)decoded).reason : "got unexpected packet";
                        }
                        receivedResp = true;
                        lock.notifyAll();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandshakeResp performHandshake(String ip2, String username, String password) throws InterruptedException, IOException {
        isHandshaking = true;
        receivedResp = false;
        resp = null;
        try {
            Client c = new Client();
            c.start();
            c.addListener(Handshake.listener());
            KryoHelper.addRegisters(c.getKryo());
            c.connect(5000, ip2, 61234);
            HandshakeReq req = new HandshakeReq(username, password);
            EncryptedPacket pkt = new EncryptedPacket(req, null);
            c.sendTCP(pkt);
            Object object = lock;
            synchronized (object) {
                long start = System.currentTimeMillis();
                while (!receivedResp) {
                    long elapsed = System.currentTimeMillis() - start;
                    long waitTime = 5000L - elapsed;
                    if (waitTime <= 0L) {
                        c.stop();
                        return resp;
                    }
                    lock.wait(waitTime);
                }
            }
            c.stop();
        }
        catch (IOException | InterruptedException e) {
            System.out.println(e.getMessage());
        }
        isHandshaking = false;
        return resp;
    }

    public static String getError() {
        return err;
    }
}

